//=============================================================================
// Balloon mother class, never spawned (on purpose lol!!)
//=============================================================================
class Balloon extends ScriptedPawn;

//Import mesh for small balloons:
#exec obj load file=..\Textures\PopBalloonsTextures.utx package=PopBalloonsTextures
#exec mesh import mesh=Balloon_small_red anivfile=Models\Balloon_small_red_a.3d datafile=Models\Balloon_small_red_d.3d x=0 y=0 z=0 mlod=0
#exec mesh origin mesh=Balloon_small_red x=0 y=0 z=0
#exec mesh sequence mesh=Balloon_small_red seq=All startframe=0 numframes=1
#exec meshmap new meshmap=Balloon_small_red mesh=Balloon_small_red
#exec meshmap scale meshmap=Balloon_small_red x=0.13148 y=0.13148 z=0.26295

//Balloon variables:
var float	speed;
var int		layers;
var float 	BaseSpeed;
var bool 	bCanBeGlued,
			bCanBeFrozen,
			bFrozen,
			bCamo;

//Navigation Variables:
var int		Route;							//what route does it travel
var Vector 	NextPath;						//Vector location of next point
var	BalloonPathNodeA PathNodeA[128];		//The array of the pathnodes that make up the track from start to end
var	BalloonPathNodeB PathNodeB[128];		//The array of the pathnodes that make up the track from start to end
var	BalloonPathNodeC PathNodeC[128];		//The array of the pathnodes that make up the track from start to end
var	BalloonPathNodeD PathNodeD[128];		//The array of the pathnodes that make up the track from start to end
var int 	PathNum;						//the current destination pathnode in the array

event Touch( Actor Other )
{
//local BalloonPathNode BPN;

	if ( Other.IsA('BalloonPathNode') )
		{
		SetNextPath();
		if ( BalloonPathNode(Other).bTeleportToNextPoint )
			{
			Self.MakeNoise(1.0);
			Level.Game.PlayTeleportEffect(Self, true, true);
			Self.SetLocation(NextPath);
			}
		}
}

function DefineBalloonPathNodes()
{
local int i;
local NavigationPoint NP;
local GRI GRI;

	GRI = GRI(DeathMatchPlus(Level.Game).GameReplicationInfo);

	//Increase balloons speed according to round
	if ( GRI.Round >= 45 )
		BaseSpeed = BaseSpeed * 1.90;
	else if ( GRI.Round >= 40 )
		BaseSpeed = BaseSpeed * 1.80;
	else if ( GRI.Round >= 35 )
		BaseSpeed = BaseSpeed * 1.70;
	else if ( GRI.Round >= 30 )
		BaseSpeed = BaseSpeed * 1.60;
	else if ( GRI.Round >= 25 )
		BaseSpeed = BaseSpeed * 1.50;
	else if ( GRI.Round >= 20 )
		BaseSpeed = BaseSpeed * 1.40;
	else if ( GRI.Round >= 15 )
		BaseSpeed = BaseSpeed * 1.30;
	else if ( GRI.Round >= 10 )
		BaseSpeed = BaseSpeed * 1.20;
	else if ( GRI.Round >= 5 )
		BaseSpeed = BaseSpeed * 1.10;
	
	//Scan map for path actors:
	for (NP = Level.NavigationPointList; NP != None; NP = NP.NextNavigationPoint)
		{
		if ( Route == 1 && NP.IsA('BalloonPathNodeA') )
			{
			PathNodeA[BalloonPathNodeA(NP).PathNum - 1] = BalloonPathNodeA(NP);
			}
		else if ( Route == 2 && NP.IsA('BalloonPathNodeB') )
			{
			PathNodeB[BalloonPathNodeB(NP).PathNum - 1] = BalloonPathNodeB(NP);
			}
		else if ( Route == 3 && NP.IsA('BalloonPathNodeC') )
			{
			PathNodeC[BalloonPathNodeC(NP).PathNum - 1] = BalloonPathNodeC(NP);
			}
		else if ( Route == 4 && NP.IsA('BalloonPathNodeD') )
			{
			PathNodeD[BalloonPathNodeD(NP).PathNum - 1] = BalloonPathNodeD(NP);
			}
		}
		
	//Set first path point:
	if ( Route == 1 )
		NextPath = PathNodeA[0].location;
	else if ( Route == 2 )
		NextPath = PathNodeB[0].location;
	else if ( Route == 3 )
		NextPath = PathNodeC[0].location;
	else if ( Route == 4 )
		NextPath = PathNodeD[0].location;
	
}

simulated function bool AdjustHitLocation(out vector HitLocation, vector TraceDir)
{
	local float adjZ, maxZ;

	TraceDir = Normal(TraceDir);
	HitLocation = HitLocation + 0.4 * CollisionRadius * TraceDir;

	return true;
}

function SetNextPath()
{
	PathNum += 1;
}

simulated function Tick(float DT) 
{
	Super.Tick(DT);
	if ( Health > 0 )
		{
		Enemy = None;
		OldEnemy = None;
		AttitudeToPlayer = ATTITUDE_Ignore;
		SetPHysics(PHYS_Flying);
		if (!IsInState('TacticalMove'))
			GotoState('TacticalMove');
	
		if ( Route == 1 )
				{
				if (VSize(PathNodeA[PathNum].location - Location) < 100)
					SetNextPath();
				}
		else if ( Route == 2 )
				{
				if (VSize(PathNodeB[PathNum].location - Location) < 100)
					SetNextPath();
				}
		else if ( Route == 3 )
				{
				if (VSize(PathNodeC[PathNum].location - Location) < 100)
					SetNextPath();
				}
		else if ( Route == 4 )
				{
				if (VSize(PathNodeD[PathNum].location - Location) < 100)
					SetNextPath();
				}
		SetColor();
		}
}

function SetColor()
{
	//used to set the color according to its health
}

function damageAttitudeTo(pawn Other)
{
	AttitudeToPlayer = ATTITUDE_Ignore;
	GotoState('TacticalMove');
}

function eAttitude AttitudeTo(Pawn Other)
{
	AttitudeToPlayer = ATTITUDE_Ignore;
	GotoState('TacticalMove');
	Return AttitudeToPlayer;
}

function SpawnGibbedCarcass()
{
}

function Carcass SpawnCarcass()
{
}

function PlayHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
local UT_SpriteSmokePuff SP;

	if ( Damage > 0 )
		{
		SP = spawn(Class'UT_SpriteSmokePuff',,,HitLocation);
		SP.DrawScale = 0.5;
		}
}

function PlayDeathHit(float Damage, vector HitLocation, name damageType, vector Momentum)
{
local FX_BalloonPop A;
local FX_BalloonKablop B;
local FX_BalloonDop C;
local FX_BalloonBop D;
local int Dice;

	Dice = Rand(4);
	
	if ( Dice == 0 )
		A = spawn(class 'FX_BalloonPop',self,'', Self.Location + Vect(0,0,5));
	else if ( Dice == 1 )
		B = spawn(class 'FX_BalloonKablop',self,'', Self.Location + Vect(0,0,5));
	else if ( Dice == 2 )
		C = spawn(class 'FX_BalloonDop',self,'', Self.Location + Vect(0,0,5));
	else
		D = spawn(class 'FX_BalloonBop',self,'', Self.Location + Vect(0,0,5));
}

//States:

state TacticalMove
{
ignores SeePlayer, HearNoise;

	function SetFall()
	{
	}

	function TakeDamage( int Damage, Pawn instigatedBy, Vector hitlocation, 
						Vector momentum, name damageType)
	{
		Global.TakeDamage(Damage, instigatedBy, hitlocation, momentum, damageType);
		if ( health <= 0 )
			return;
		if ( NextState == 'TakeHit' )
		{
			NextState = 'TacticalMove'; 
			NextLabel = 'TakeHit';
			GotoState('TakeHit'); 
		}
	}

	function HitWall(vector HitNormal, actor Wall)
	{
	}

	function FearThisSpot(Actor aSpot)
	{
	}

	function AnimEnd() 
	{
	}

	function Timer()
	{
	}

	function EnemyNotVisible()
	{
	}

	function bool ValidRecovery()
	{
	}
		
	function GiveUpTactical(bool bNoCharge)
	{	
	}		

/* PickDestination()
Choose a destination for the tactical move, based on aggressiveness and the tactical
situation. Make sure destination is reachable
*/
	function PickDestination(bool bNoCharge)
	{
	if ( Route == 1 )
		{
		DesiredRotation = Rotator(PathNodeA[PathNum].Location - Location);
		Focus = PathNodeA[PathNum].Location;
		Destination = PathNodeA[PathNum].Location;
		}
	else if ( Route == 2 )
		{
		DesiredRotation = Rotator(PathNodeB[PathNum].Location - Location);
		Focus = PathNodeB[PathNum].Location;
		Destination = PathNodeB[PathNum].Location;
		}
	else if ( Route == 3 )
		{
		DesiredRotation = Rotator(PathNodeC[PathNum].Location - Location);
		Focus = PathNodeC[PathNum].Location;
		Destination = PathNodeC[PathNum].Location;
		}
	else if ( Route == 4 )
		{
		DesiredRotation = Rotator(PathNodeD[PathNum].Location - Location);
		Focus = PathNodeD[PathNum].Location;
		Destination = PathNodeD[PathNum].Location;
		}
	}

	function BeginState()
	{
	}
	
	function EndState()
	{
	}

//FIXME - what if bReadyToAttack at start
TacticalTick:
	Sleep(0.02);	
Begin:
	PickDestination(false);

DoMove:
	MoveTo(Destination);
	
NoCharge:
	if ( Route == 1 )
		{
		DesiredRotation = Rotator(PathNodeA[PathNum].Location - Location);
		Focus = PathNodeA[PathNum].Location;
		Destination = PathNodeA[PathNum].Location;
		}
	else if ( Route == 2 )
		{
		DesiredRotation = Rotator(PathNodeB[PathNum].Location - Location);
		Focus = PathNodeB[PathNum].Location;
		Destination = PathNodeB[PathNum].Location;
		}
	else if ( Route == 3 )
		{
		DesiredRotation = Rotator(PathNodeC[PathNum].Location - Location);
		Focus = PathNodeC[PathNum].Location;
		Destination = PathNodeC[PathNum].Location;
		}
	else if ( Route == 4 )
		{
		DesiredRotation = Rotator(PathNodeD[PathNum].Location - Location);
		Focus = PathNodeD[PathNum].Location;
		Destination = PathNodeD[PathNum].Location;
		}
	Goto('DoMove');
	
AdjustFromWall:
	StrafeTo(Destination, Focus); 
	Destination = Focus; 
	Goto('DoMove');

TakeHit:
	Goto('DoMove');

RecoverEnemy:
	MoveTo(Destination);
	Goto('DoMove');
}

defaultproperties
{
	 DrawType=DT_Mesh
	 layers=1
	 speed=1.000000
	 BaseSpeed=90.000000
     AmbientGlow=64
     CollisionHeight=11.000000
	 PathNum=0
	 bCollideActors=True
	 bCollideWorld=False
	 bBlockActors=False
	 bBlockPlayers=True
	 bProjTarget=True
	 bHidden=False
	 GroundSpeed=200.000000
	 AirSpeed=200.000000
     WaterSpeed=200.000000
     AccelRate=500.000000
	 bCanBeGlued=True
	 bCanBeFrozen=True
	 bFrozen=False
	 bCamo=False
	 DrawScale=1.000000
}
